import Sirius.columnchart.*;
import java.applet.Applet;
import java.awt.*;
import java.util.*;
import java.awt.image.*;
import java.net.*;
import java.lang.*;

public class ColumnchartApplet extends Applet
{

    // Bean Object
    private Columnchart columnchart;

    // Data Objects
    private Vector imagedata;   // Image Objects
    private Vector textdata;    // Text Objects
    private Vector titledata;   // Title Objects (Main Title, X Title, Y Title)
    private Vector xlabelsdata; // X labels Objects
    private Vector ylabelsdata; // Y labels Objects
    private Vector columndata;  // Point data Objects
    private Vector seriesdata;  // Series data Objects
    private Vector chartdata;   // Chart Properties Object
    private Vector legenddata;  // Legend Properties
    private Vector minmaxdata;  // Min Max Data lines

    public ColumnchartApplet()
    {
    }

    public void init()
    {
        columnchart = new Columnchart();

        set_imagedata();
        set_chartdata();
        set_legenddata();
        set_titledata();
        set_textdata();
        set_xlabelsdata();
        set_ylabelsdata();
        set_seriescolumndata();
        set_minmaxdata();

        columnchart.resize(500,420);

        setLayout(null);
        setBackground(Color.white);
        add(columnchart);
    }



//-----------------------------------------------------------------------------
// Create the chartdata object
//
    private void set_chartdata() {
      chartdata = new Vector();

      chartdata.addElement(new Chartdata(true,                   // threeD
                                         true,                   // grid
                                         true,                   // axis
                                         true,                   // ylabels
                                         true,                   // outline
                                         true,                   // legend
                                         500,                    // width
                                         420,                    // height
                                         4,                      // number of columns,
                                         7,                      // number of nrows,
                                         30,                     // vertical spacing,
                                         3,                      // number of series,
                                         80,                     // horizontal spacing,
                                         75,                     // gridxpos,
                                         350,                    // gridypos,
                                         15,                     // depth3D,
                                         0,                      // ndecplaces,
                                         20,                     // Column width
                                         1000,                   // chartScale,
                                         6000,                   // chartStartY,
                                         new Color(100,100,100), // gridColor,
										 new Color(0,0,0),       // axisColor,
										 new Color(100,100,100), // floorColor,
										 new Color(0,0,0),       // labelColor,
                                         new Color(255,255,255), // backgroundColor
                                         new Color(0,0,0)        // Outline Color
                                        ));

      columnchart.setChartdata(chartdata);
	}
//-----------------------------------------------------------------------------
// Create the legenddata object
//
    private void set_legenddata() {
       legenddata = new Vector();
       legenddata.addElement(new Legenddata("Products",                        // Legend title
                                            new Color(0,0,0),                  // Legend text color
                                            new Font("Courier",Font.PLAIN,12), // Legend text font
                                            new Point(400,100)                 // Legend top-left position (x,y)
                                           ));
       columnchart.setLegenddata(legenddata);
	}
//-----------------------------------------------------------------------------
// Create the  titledata object
//
    private void set_titledata() {
       titledata = new Vector();
       titledata.addElement(new Titledata("Sales by Quarter",new Color(100,100,100),new Font("TimesRoman",Font.BOLD + Font.ITALIC,18),new Point(50,20)));
       titledata.addElement(new Titledata("Year 2001",new Color(100,100,100),new Font("TimesRoman",Font.BOLD,16),new Point(200,400)));
       titledata.addElement(new Titledata("Value $",new Color(100,100,100),new Font("TimesRoman",Font.BOLD,16),new Point(10,300)));
       columnchart.setTitledata(titledata);
	}
//-----------------------------------------------------------------------------
// Create the Images data object
//
    private void set_imagedata() {
       imagedata = new Vector();
       imagedata.addElement(new Imagedata("meter1.gif", downloadImage("meter1.gif"), new Point(570,100)));
       imagedata.addElement(new Imagedata("tools1.gif", downloadImage("tools1.gif"), new Point(570,118)));
       imagedata.addElement(new Imagedata("drill.gif", downloadImage("drill1.gif"), new Point(570,136)));
	   columnchart.setImagedata(imagedata);
	}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// Create the text object
//

    private void set_textdata() {
       textdata = new Vector();
       textdata.addElement(new Textdata("Note:",                           // Text line 1
                                        new Color(0,0,255),                // text color
                                        new Font("TimesRoman",Font.PLAIN,12),  // text font
                                        new Point(80,60)                   // text position (x,y)
                                        ));
       textdata.addElement(new Textdata("New product range",               // Text line 2
                                        new Color(0,0,0),                  // text color
                                        new Font("TimesRoman",Font.PLAIN,12), // text font
                                        new Point(80,80)                   // text position (x,y)
                                        ));
       textdata.addElement(new Textdata("launched during",                 // Text line 3
                                        new Color(0,0,0),                  // text color
                                        new Font("TimesRoman",Font.PLAIN,12), // text font
                                        new Point(80,100)                  // text position (x,y)
                                        ));
       textdata.addElement(new Textdata("quarter 2.",                      // Text line 3
                                        new Color(0,0,0),                  // text color
                                        new Font("TimesRoman",Font.PLAIN,12), // text font
                                        new Point(80,120)                  // text position (x,y)
                                        ));

       columnchart.setTextdata(textdata);
	}
//-----------------------------------------------------------------------------
// Create the xlabels object
//
    private void set_xlabelsdata() {
       xlabelsdata = new Vector();
       xlabelsdata.addElement(new Xlabelsdata("Quarter 1",new Color(0,0,0),new Font("TimesRoman",Font.PLAIN,10), 375, 0));
       xlabelsdata.addElement(new Xlabelsdata("Quarter 2",new Color(0,0,0),new Font("TimesRoman",Font.PLAIN,10), 375, 0));
       xlabelsdata.addElement(new Xlabelsdata("Quarter 3",new Color(0,0,0),new Font("TimesRoman",Font.PLAIN,10), 375, 0));
       xlabelsdata.addElement(new Xlabelsdata("Quarter 4",new Color(0,0,0),new Font("TimesRoman",Font.PLAIN,10), 375, 0));
       columnchart.setXlabelsdata(xlabelsdata);
	}

//-----------------------------------------------------------------------------
// Create the ylabels data object
//
    private void set_ylabelsdata() {
       ylabelsdata = new Vector();
       ylabelsdata.addElement(new Ylabelsdata(new Color(0,0,0),new Font("TimesRoman",Font.PLAIN,10)));
       columnchart.setYlabelsdata(ylabelsdata);
	}
//-----------------------------------------------------------------------------
// Create the  series and column objects
//

    private void set_seriescolumndata() {
         seriesdata = new Vector();

         // Series 1
         columndata = new Vector();
         columndata.addElement(new Columndata(7000, false));
         columndata.addElement(new Columndata(7900, false));
         columndata.addElement(new Columndata(10350, false));
         columndata.addElement(new Columndata(13800, false));
         seriesdata.addElement(new Seriesdata("Product X", new Color(200,0,0), columndata));

         // Series 2
         columndata = new Vector();
	     columndata.addElement(new Columndata(6300, false));
	     columndata.addElement(new Columndata(6400, false));
	     columndata.addElement(new Columndata(8700, false));
	     columndata.addElement(new Columndata(9200, false));
         seriesdata.addElement(new Seriesdata("Product Y", new Color(200,0,200), columndata));

         // Series 3
         columndata = new Vector();
	     columndata.addElement(new Columndata(6000, false));
	     columndata.addElement(new Columndata(6200, false));
	     columndata.addElement(new Columndata(7000, false));
	     columndata.addElement(new Columndata(7750, false));
         seriesdata.addElement(new Seriesdata("Product Z", new Color(0,200,0), columndata));

         columnchart.setSeriesdata(seriesdata);
	}
//-----------------------------------------------------------------------------
// Create the Min Max Line data object
//
    private void set_minmaxdata() {
		minmaxdata = new Vector();
		minmaxdata.addElement(new MinMaxdata("   Target",new Color(0,100,0), new Font("Arial",Font.BOLD,12),8700,1));
		columnchart.setMinmaxdata(minmaxdata);
	}
//-----------------------------------------------------------------------------

//DownloadImage--------------------------------------------------------------------------------

    public Image downloadImage(String img) {
		int pixs[];
        MediaTracker tracker;
        tracker = new MediaTracker(this);
        Image di = getImage(getCodeBase(), img);
        tracker.addImage(di, 0);
        try {
            showStatus("Loading Image...");
            tracker.waitForID(0);
            showStatus("");
        }
        catch(InterruptedException e) {
             return createImage(size().width, size().height);
        }
    //MakeVMThinkTheImageSourceIsMemory______________________________________
        int w = di.getWidth(this);
        int h = di.getHeight(this);
        pixs = new int[w * h];
        PixelGrabber pg = new PixelGrabber(di, 0, 0, w, h, pixs, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            showStatus("Image loading error");
            return createImage(size().width, size().height);
        }
        if((pg.status() & ImageObserver.ABORT) != 0) {
            System.err.println("image fetch aborted or errored");
            showStatus("Image loading error");
            return createImage(size().width, size().height);
        }
        di = createImage(new MemoryImageSource(w, h, pixs, 0, w));
        int index = 0;
        return di;
    } // End download image method



//----------------------------------------------------------------------------------
} // End Applet class